cd "Z:\work\Baze\SILC_Serbia\2019"
*use the following link for the instructions 
* on how to compute variables
* https://ec.europa.eu/eurostat/documents/1012329/6070906/Household+data+-+income.pdf
* https://ec.europa.eu/eurostat/web/income-and-living-conditions/methodology

**********************************
** extract individual vars *******
**********************************
use p-file, clear

* agregate on the household level
foreach var in py010n py021n py050n py080n py090n py100n ///
			   py110n py120n py130n py140n py010g py021g ///
			   py050g py080g py090g py100g py110g py120g ///
			   py130g py140g {
bys idhh: egen `var'_hh = sum(`var')
}


* keep necessary variables
keep idhh *_hh
duplicates drop idhh, force
sum
save p-file_hh, replace

**********************************
** househod vars *****************
** merged with individual vars ***
**********************************

use h-file, clear
merge 1:1 idhh using p-file_hh
drop _merge

* Total household gross income
* calculate from the data and compare
egen grossy = rowtotal (py010g_hh py021g_hh ///
					   py050g_hh py080g_hh ///
					   py090g_hh py100g_hh ///
					   py110g_hh py120g_hh ///
					   py130g_hh py140g_hh ///
					   hy040g hy050g hy060g ///
					   hy070g hy080g hy090g ///
					   hy110g)
sum grossy hy010
gen dif = hy010 - grossy
/*recode dif (-0.9999 / 0.9999 = 0)
replace dif = int(dif)
ta dif*/

* Total disposable household income
* calculate from the data and compare
* - hy120g (all values are zero)
gen dispy = grossy - hy130g - hy140g 
sum dispy hy020

* Total disposable household income ///
* before social transfers except ///
* old-age and survivor’ benefits
gen dispy2 = dispy - py090g_hh - py120g_hh - ///
			 py130g_hh - py140g_hh - hy050g - ///
			 hy060g - hy070g
sum dispy2 hy022

* Total disposable household income ///
* before social transfers including ///
* old-age and survivor’ benefits
gen dispy3 = dispy2 - py100g_hh - py110g_hh
sum dispy3 hy023

/* values in py100g_hh (Old-age benefits) 
and py110g_hh (Survivor' benefits) are responsible 
for the difference in calculated disposable incomes 
as dispy3 and hy023 are equal */

* correct for difference in old age and survivor benefits
gen dispy_cor = dispy + dif
sum dispy_cor hy020

* Total disposable household income ///
* bottom up calculation
egen dispy_n = rowtotal (py010n_hh py021n_hh ///
					   py050n_hh py080n_hh ///
					   py090n_hh py100n_hh ///
					   py110n_hh py120n_hh ///
					   py130n_hh py140n_hh ///
					   hy040n hy050n hy060n ///
					   hy070n hy080n hy090n ///
					   hy110n)
replace dispy_n = dispy_n - hy130n					   
sum dispy_n hy020

* correct for difference in old age and survivor benefits
gen dispy_n_cor = dispy_n + dif
sum dispy_cor dispy_n_cor hy020

keep idhh dif 
save dif_hh, replace








